
(defmeth vista-graph-overlay-proto :draw-button 
  (paint i &key (plus-minus nil set) bottom (vr (list 0 0 0 0))
         (button-color 'black) (text-color 'black) 
         (vertical nil) (y 3))
  (let* ((graph (slot-value 'graph))
         (button-list (send self :buttons))
         (lefts (send self :lefts))
         (a (+ (first vr)(select (send self :lefts) i)))
         (ab)
         (on-color 'button-on-color)
         (off-color 'button-off-color)
         (draw-color (send graph :draw-color))
         (vertical-offset (send self :vertical-offset))
         (h (- (second (send graph :size)) (fourth (send graph :margin))))
         (b (+ 2 (second vr) y))
         (c 8)
         (d 8))
    (when (> (min (send graph :size)) 0)
          (when (and vertical (not (send self :vertical-offset)))
                (send self :initialize-vertical-offset (send self :strings)))
          (when bottom
                (setf b (+ 4 (- (send graph :canvas-height) 
                                (fourth (send graph :margin))))))
          (when (not button-list)
                (send self :buttons (repeat nil (length (send self :lefts)))))
          (setf (select button-list i) paint)
          (send self :buttons button-list)
          (when (or (= *color-mode* 0) (not (send graph :use-color)))
                (setf on-color 'black)
                (setf off-color 'white))
          (when vertical (setf ab (send self :get-vertical-bar-location a b h 0))
                (setf a (first ab))
                (setf b (second ab)))
          (send (send self :graph) :draw-color 'black)
          (send (send self :graph) :frame-rect (- a 1) (- b 1) (+ c 3) (+ d 3))
          (send (send self :graph) :frame-rect (- a 2) (- b 2) (+ c 3) (+ d 3))
          (cond 
            (paint 
             (send (send self :graph) :draw-color on-color)
             (send (send self :graph) :paint-rect a b c d))
            (t
             (send (send self :graph) :draw-color off-color)
             (send (send self :graph) :paint-rect a b c d)))
          (send (send self :graph) :draw-color 'black)
          (send (send self :graph) :frame-rect a b c d)
          (send graph :draw-color text-color)
          
          (if vertical
              (send graph :draw-string-up (select (send self :strings) i) 
                    (+ a (- c 1)) (- b 2))
              (send graph :draw-string (select (send self :strings) i) 
                    (+ a d 3) (+ b (- c 0))))
          (send graph :draw-color draw-color)
          
          (when set
                (let ((lw (send graph :line-width))
                      (g 1)
                      (h 0)
                      (j 1))
                  #+macintosh (setf g 0)
                  #+macintosh (setf h 1) 
                  #+macintosh (setf j 0)
                  (send graph :draw-line 
                        (+ g a 1)       (- (+ b (ceiling (/ d 2))) h)
                        (+ a g (- c 3)) (- (+ b (ceiling (/ d 2))) h))
                  (send graph :draw-line 
                        (+ g a 1) (- (+ b (ceiling (/ d 2))) h 1)
                        (+ a g (- c 3)) (- (+ b (ceiling (/ d 2))) h 1))
                  (when plus-minus
                        (send graph :draw-line
                              (+ a g (- (floor (/ c 2)) 1)) (+ b j 1)
                              (+ a g (- (floor (/ c 2)) 1)) (+ b j (- d 3)))
                        (send graph :draw-line
                              (+ a g (- (floor (/ c 2)) 2)) (+ b j 1)
                              (+ a g (- (floor (/ c 2)) 2)) (+ b j (- d 3))))
                  
                  (send graph :line-width lw)))
          (list a b))))


(defmeth vista-graph-overlay-proto :draw-button 
  (paint i &key (plus-minus nil set) bottom (vr (list 0 0 0 0))
         (button-color 'black) (text-color 'black) 
         (vertical nil) (y 3))
  (let* ((graph (slot-value 'graph))
         (button-list (send self :buttons))
         (lefts (send self :lefts))
         (a (+ (first vr)(select (send self :lefts) i)))
         (ab)
         (on-color 'button-on-color)
         (off-color 'button-off-color)
         (draw-color (send graph :draw-color))
         (vertical-offset (send self :vertical-offset))
         (h (- (second (send graph :size)) (fourth (send graph :margin))))
         (b (+ (second vr) y))
         (c 10)
         (d 10))
    (when (> (min (send graph :size)) 0)
          (when (and vertical (not (send self :vertical-offset)))
                (send self :initialize-vertical-offset (send self :strings)))
          (when bottom
                (setf b (+ 4 (- (send graph :canvas-height) 
                                (fourth (send graph :margin))))))
          (when (not button-list)
                (send self :buttons (repeat nil (length (send self :lefts)))))
          (setf (select button-list i) paint)
          (send self :buttons button-list)
          (when (or (= *color-mode* 0) (not (send graph :use-color)))
                (setf on-color 'black)
                (setf off-color 'white))
          (when vertical (setf ab (send self :get-vertical-bar-location a b h 0))
                (setf a (first ab))
                (setf b (second ab)))
          (send (send self :graph) :draw-color 'black)
          (send (send self :graph) :frame-rect (- a 2) (- b 1) (+ c 3) (+ d 3))
          (cond 
            (paint 
             (send (send self :graph) :draw-color on-color)
             (send (send self :graph) :paint-rect (- a 2) (- b 1) (+ c 2) (+ d 2))
             
             (send (send self :graph) :draw-color 'black)
             (send (send self :graph) :frame-rect (- a 2) (- b 1) (+ c 3) (+ d 3))
             (send (send self :graph) :draw-color 'light-grey) ;off-color
             (send (send self :graph) :frame-rect (- a 2) (- b 1) (+ c 2) (+ d 2))
             (send (send self :graph) :draw-color 'white) ;button-color
             (send (send self :graph) :frame-rect (- a 1) (- b 0) (+ c 1) (+ d 1)))
            (t
             (send (send self :graph) :draw-color 'light-grey) ;off-color
             (send (send self :graph) :paint-rect (- a 2) (- b 1) (+ c 2) (+ d 2))
             (send (send self :graph) :draw-color 'white) ;button-color
             (send (send self :graph):frame-rect (- a 1) (- b 0) (+ c 1) (+ d 1))
             ))
            
          (send graph :draw-color text-color)
          
          (if vertical
              (send graph :draw-string-up (select (send self :strings) i) 
                    (+ a (- c 1)) (- b 2))
              (send graph :draw-string (select (send self :strings) i) 
                    (+ a d 2) (+ b (- c 1))))
          (send graph :draw-color draw-color)
          
          (when set
                (let ((lw (send graph :line-width))
                      (g 1)
                      (h 0)
                      (j 1))
                  #+macintosh (setf g 0)
                  #+macintosh (setf h 1) 
                  #+macintosh (setf j 0)
                  (send graph :draw-line 
                        (+ g a 1)       (- (+ b (ceiling (/ d 2))) h)
                        (+ a g (- c 3)) (- (+ b (ceiling (/ d 2))) h))
                  (send graph :draw-line 
                        (+ g a 1) (- (+ b (ceiling (/ d 2))) h 1)
                        (+ a g (- c 3)) (- (+ b (ceiling (/ d 2))) h 1))
                  (when plus-minus
                        (send graph :draw-line
                              (+ a g (- (floor (/ c 2)) 1)) (+ b j 1)
                              (+ a g (- (floor (/ c 2)) 1)) (+ b j (- d 3)))
                        (send graph :draw-line
                              (+ a g (- (floor (/ c 2)) 2)) (+ b j 1)
                              (+ a g (- (floor (/ c 2)) 2)) (+ b j (- d 3))))
                  
                  (send graph :line-width lw)))
          (list a b))))








(defmeth vista-graph-overlay-proto :draw-button 
  (paint i &key (plus-minus nil set) bottom (vr (list 0 0 0 0))
         (button-color 'black) (text-color 'black) 
         (vertical nil) (y 3))
  (let* ((graph (slot-value 'graph))
         (button-list (send self :buttons))
         (lefts (send self :lefts))
         (a (+ (first vr)(select (send self :lefts) i)))
         (ab)
         (on-color 'button-on-color)
         (off-color 'button-off-color)
         (draw-color (send graph :draw-color))
         (vertical-offset (send self :vertical-offset))
         (h (- (second (send graph :size)) (fourth (send graph :margin))))
         (b (+ (second vr) y))
         (c 10)
         (d 10))
    (when (> (min (send graph :size)) 0)
          (when (and vertical (not (send self :vertical-offset)))
                (send self :initialize-vertical-offset (send self :strings)))
          (when bottom
                (setf b (+ 4 (- (send graph :canvas-height) 
                                (fourth (send graph :margin))))))
          (when (not button-list)
                (send self :buttons (repeat nil (length (send self :lefts)))))
          (setf (select button-list i) paint)
          (send self :buttons button-list)
          (when (or (= *color-mode* 0) (not (send graph :use-color)))
                (setf on-color 'black)
                (setf off-color 'white))
          (when vertical (setf ab (send self :get-vertical-bar-location a b h 0))
                (setf a (first ab))
                (setf b (second ab)))
          (cond 
            (paint 
             (send (send self :graph) :draw-color button-color)
             (send (send self :graph) :frame-rect (1+ a) (1+ b) c d)
             (send (send self :graph) :draw-color on-color)
             (send (send self :graph) :paint-rect a b c d)
             (send (send self :graph) :draw-color button-color)
             (send (send self :graph) :frame-rect a b c d))
            (t
             
             (send (send self :graph) :draw-color button-color)
             (send (send self :graph) :frame-rect (1+ a) (1+ b) c d)
             (send (send self :graph) :draw-color off-color)
             (send (send self :graph) :paint-rect a b c d)
             (send (send self :graph) :draw-color button-color)
             (send (send self :graph) :frame-rect a b c d)))
          (send graph :draw-color text-color)
          
          (if vertical
              (send graph :draw-string-up (select (send self :strings) i) 
                    (+ a (- c 1)) (- b 2))
              (send graph :draw-string (select (send self :strings) i) 
                    (+ a d 2) (+ b (- c 1))))
          (send graph :draw-color draw-color)
          
          (when set
                (let ((lw (send graph :line-width))
                      (g 1)
                      (h 0)
                      (j 1))
                  #+macintosh (setf g 0)
                  #+macintosh (setf h 1) 
                  #+macintosh (setf j 0)
                  (send graph :draw-line 
                        (+ g a 1)       (- (+ b (ceiling (/ d 2))) h)
                        (+ a g (- c 3)) (- (+ b (ceiling (/ d 2))) h))
                  (send graph :draw-line 
                        (+ g a 1) (- (+ b (ceiling (/ d 2))) h 1)
                        (+ a g (- c 3)) (- (+ b (ceiling (/ d 2))) h 1))
                  (when plus-minus
                        (send graph :draw-line
                              (+ a g (- (floor (/ c 2)) 1)) (+ b j 1)
                              (+ a g (- (floor (/ c 2)) 1)) (+ b j (- d 3)))
                        (send graph :draw-line
                              (+ a g (- (floor (/ c 2)) 2)) (+ b j 1)
                              (+ a g (- (floor (/ c 2)) 2)) (+ b j (- d 3))))
                  
                  (send graph :line-width lw)))
          (list a b))))